<?php

namespace App\Http\Controllers\App;

use Illuminate\Support\Facades\Schema;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class ProfileController extends Controller
{



   
    // Add new profile (Create)
    public function addProfile(Request $request)
    {
        // Validate input
        $request->validate([
            'iStudentId' => 'required|numeric',
            'sName' => 'nullable|string',
            'iDeviceId' => 'nullable|string',
            'sAddress' => 'nullable|string',
            'sFatherName' => 'nullable|string',
            'sMotherName' => 'nullable|string',
            'dtCandidateBirthDate' => 'nullable|string',
            'sPremiseaNo' => 'nullable|string',
            'sSubLocality' => 'nullable|string',
            'sLocality' => 'nullable|string',
            'sCountry'=>'nullable|string',
            'sState'=>'nullable|string',
            'iBisActive' => 'nullable|boolean',
            'sOtherDetails1' => 'nullable|string',
            'sOtherDetails2' => 'nullable|string',
            'sOtherDetails3' => 'nullable|string',
            'sOtherDetails4' => 'nullable|string',
        ]);

        // Prepare data
        $data = $request->only([
            'iStudentId', 'sName', 'iDeviceId','sAddress', 'sFatherName', 'sMotherName','dtCandidateBirthDate','sPremiseaNo','sSubLocality','sLocality','sCountry','sState','iBisActive', 
            'sOtherDetails1', 'sOtherDetails2', 'sOtherDetails3', 'sOtherDetails4'
        ]);
        $data['dtUpdatedDate'] = now();
        // Insert student data into the database using DB::table()
        $studentId = DB::table('tblAppUser')->insertGetId($data);

        // Return success response
        return response()->json([
            'message' => 'Student added successfully',
            'data' => ['iId' => $studentId], // Returning the inserted student ID,
            'result'=>'1'
        ], 201);
    }




    // Get student profile by ID (Read)
    public function getProfile($id)
    {
        // Find student by ID using DB::table() 
        $student = DB::table('tblAppUser')
            ->where('iId', $id)
            ->first();  // Using first() to get a single result

        if (!$student) {
            // Return error if student not found
            return response()->json([
                'message' => 'Student not found'
            ], 404);
        }

        // Return student data
        return response()->json($student);
    }




    // get all
    public function getAllProfile()
    {

        $profile = DB::table('tblAppUser')->where('iBisActive' , 1)->get();


        return response()->json($profile);
    }




    // Update student profile (Update)
    public function updateProfile(Request $request)
    {
        // Validate input
        $request->validate([
           'iStudentId' => 'required|numeric',
            'sName' => 'nullable|string',
            'iDeviceId' => 'nullable|string',
            'sAddress' => 'nullable|string',
            'sFatherName' => 'nullable|string',
            'sMotherName' => 'nullable|string',
            'dtCandidateBirthDate' => 'nullable|string',
            'sPremiseaNo' => 'nullable|string',
            'sSubLocality' => 'nullable|string',
            'sLocality' => 'nullable|string',
            'sCountry'=>'nullable|string',
            'sState'=>'nullable|string',
            'iBisActive' => 'nullable|boolean',
            'sOtherDetails1' => 'nullable|string',
            'sOtherDetails2' => 'nullable|string',
            'sOtherDetails3' => 'nullable|string',
            'sOtherDetails4' => 'nullable|string',
        ]);
        $id =  $request->input('iId');

        // Find student by ID using DB::table()
        $student = DB::table('tblAppUser')
            ->where('iId', $id)
            ->first();  // Check if student exists

        if (!$student) {
            // Return error if student not found
            return response()->json([
                'message' => 'Student not found'
            ], 404);
        }

        // Prepare data for update
        $data = $request->only([
             'iStudentId', 'sName', 'iDeviceId','sAddress', 'sFatherName', 'sMotherName','dtCandidateBirthDate','sPremiseaNo','sSubLocality','sLocality','sCountry','sState','iBisActive', 
            'sOtherDetails1', 'sOtherDetails2', 'sOtherDetails3', 'sOtherDetails4'
        ]);
        $data['dtUpdatedDate'] = now();

        // Update student data in the database using DB::table()
        DB::table('tblAppUser')
            ->where('iId', $id)
            ->update($data);  // Use update() method to update student data

        // Return success response
        return response()->json([
            'message' => 'Student updated successfully',
            'data' => $data,
            'result'=>'3'
        ]);
    }





    // Delete student profile (Delete)
    public function deleteProfile($id)
    {
        // Find student by ID using DB::table()
        $student = DB::table('tblAppUser')
            ->where('iId', $id)
            ->first();  // Check if student exists

        if (!$student) {
            // Return error if student not found
            return response()->json([
                'message' => 'Student not found'
            ], 404);
        }

        // Delete student profile from the database using DB::table()
        DB::table('tblAppUser')
            ->where('iId', $id)
            ->delete();  // Use delete() to remove the record

        // Return success response
        return response()->json([
            'message' => 'Student deleted successfully'
        ]);
    }


    
    // Get student profile by ID (Read)
    public function getProfileBystudentId($id)
    {
        // Find student by ID using DB::table()
        $student = DB::table('tblAppUser')
            ->where('iStudentId', $id)
            ->first(); // Using first() to get a single result
    
        if (!$student) {
            // Return error if student not found
            return response()->json([
                'message' => 'Student not found',
                'result' => '0'
            ]);
        }
    
        // Convert the student object to an associative array
        $studentArray = (array) $student;
    
        // Return student data as an array inside another array
        return response()->json([
            'data' => [$studentArray], // Wrapping in an array
            'result' => '1'
        ]);
    }
    

}
