<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class DocumentController extends Controller
{
    
    
    // Get all active documents
    public function getAllDocuments()
    {
        $documents = DB::table('tblDocument')->where('iBisActive', 1)->get();
    
        return response()->json([
            'data' => $documents,
            'result' => "1"
        ]);    
        
    }
    
    
    
    

    // Get a single active document by ID
    public function getDocument($iId)
    {
        $document = DB::table('tblDocument')->where('iId', $iId)->where('iBisActive', 1)->first();
        return response()->json($document ?? ['message' => 'Document not found'], $document ? 200 : 404);
    }





    // Add a new document
    public function addDocument(Request $request)
    {
        $data = $request->all();
        $data['dtUpadatedDate'] = now();
        $data['iBisActive'] = 1;

        $id = DB::table('tblDocument')->insertGetId($data);

        return response()->json(['message' => 'Document added successfully', 'iId' => $id , 'result'=> '2'], 201);
    }
    
    
    
    

    // Update a document (Only requires iId, updates the timestamp)
    public function updateDocument(Request $request)
    {
    $iId = $request->input('iId');

    if (!$iId) {
        return response()->json(['message' => 'iId is required'], 400);
    }

    $updateData = $request->except(['iId']); // Exclude iId from update fields
    $updateData['dtUpadatedDate'] = now(); // Always update the timestamp

    $update = DB::table('tblDocument')->where('iId', $iId)->update($updateData);

    return response()->json(['message' => $update ? 'Document updated' : 'No changes made', 'result'=> '3']);
}

    
    
    
    

    // Soft delete a document (Set iBisActive = 0)
    public function deleteDocument($id)
    {
    $deleted = DB::table('tblDocument')->where('iId', $id)->update(['iBisActive' => 0]);

    return response()->json([
        'message' => $deleted ? 'Document deleted' : 'Document not found','result'=>'4'
    ]);
}

    
    
      public function addMultipleDocuments(Request $request)
    {
        try {
            $request->validate([
                'document' => 'required|array',
                'document.*.sProgram' => 'required|string',
                'document.*.sCategory' => 'required|string',
                'document.*.sDocumentRequiredFor' => 'required|string',
                'document.*.sDocument' => 'required|string',
                'document.*.sDocumentUrl' => 'nullable|string',
                 
            ]);
    
            $document = $request->input('document');
            $status = $request->input('status', 'append'); 
            $sProgram = $request->input('sProgram', []); 
    
            \Log::info('Received status:', ['status' => $status]);
            \Log::info('Received sProgram:', ['sProgram' => $sProgram]);
    
            if ($status === 'addall') {
                if (!empty($sProgram) && is_array($sProgram)) {
                    \Log::info('Programs to delete:', ['programs' => $sProgram]);
    
                    foreach ($sProgram as $program) {
                        $deletedRows = DB::table('tblDocument')->where('sProgram', $program)->delete();
                        \Log::info('Deleted rows for program', ['program' => $program, 'deleted' => $deletedRows]);
                    }
                } else {
                    \Log::info('No programs provided, truncating the entire table.');
                    DB::table('tblDocument')->truncate();
                }
            }
    
            $currentDate = now(); 
            $insertData = []; 
    
            foreach ($document as $matrix) {
                $insertData[] = [
                    'sProgram' => $matrix['sProgram'],
                    'sCategory' => $matrix['sCategory'],
                    'sDocumentRequiredFor' => $matrix['sDocumentRequiredFor'],
                    'sDocument' => $matrix['sDocument'],
                    'sDocumentUrl' => $matrix['sDocumentUrl'],
                    'dtUpadatedDate' => $currentDate,
                    'iBisActive' => 1,
                ];
            }
    
            $batchSize = 1800;
            $chunks = array_chunk($insertData, $batchSize);
    
            foreach ($chunks as $chunk) {
                DB::table('tblDocument')->insert($chunk);
            }
    
            \Log::info('Multiple Documents Added successfully.');
    
            return response()->json(['result' => '2', 'message' => 'Multiple Documents Added'], 201);
        } catch (\Exception $e) {
            \Log::error('Error in addMultipledocument:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
    
            return response()->json(['result' => '0', 'message' => 'An error occurred while adding documents.'], 500);
        }
    }
    
    
    
    
    
    public function getDistinctProgramsfordoc()
    {
    try {
        $programs = DB::table('tblDocument')
            ->select('sProgram')
            ->distinct()
            ->whereNotNull('sProgram') // Optional: exclude nulls
            ->where('sProgram', '!=', '') // Optional: exclude empty strings
            ->orderBy('sProgram')
            ->get();

        return response()->json([
            'result' => '1',
            'data' => $programs
        ]);
    } catch (\Exception $e) {
        return response()->json([
            'result' => '0',
            'message' => 'Error fetching distinct programs',
            'error' => $e->getMessage()
        ], 500);
    }
}


    public function getDistinctCategoriesByProgram(Request $request)
    {
    $request->validate([
        'sProgram' => 'required|string'
    ]);

    try {
        $categories = DB::table('tblDocument')
            ->select('sCategory')
            ->distinct()
            ->where('sProgram', $request->input('sProgram'))
            ->where('iBisActive', 1)
            ->whereNotNull('sCategory')
            ->where('sCategory', '!=', '')
            ->orderBy('sCategory')
            ->get();

        return response()->json([
            'result' => '1',
            'data' => $categories
        ]);
    } catch (\Exception $e) {
        \Log::error('Error fetching categories:', ['error' => $e->getMessage()]);
        return response()->json([
            'result' => '0',
            'message' => 'Error fetching categories',
            'error' => $e->getMessage()
        ], 500);
    }
}


    public function getDocumentsByProgramAndCategory(Request $request)
    {
    $request->validate([
        'sProgram' => 'required|string',
        'sCategory' => 'nullable|string'
    ]);

    try {
        $query = DB::table('tblDocument')
            ->where('sProgram', $request->input('sProgram'))
            ->where('iBisActive', 1);

        if ($request->filled('sCategory')) {
            $query->where('sCategory', $request->input('sCategory'));
        }

        $documents = $query->get();

        return response()->json([
            'result' => '1',
            'data' => $documents
        ]);
    } catch (\Exception $e) {
        \Log::error('Error fetching documents:', ['error' => $e->getMessage()]);
        return response()->json([
            'result' => '0',
            'message' => 'Error fetching documents',
            'error' => $e->getMessage()
        ], 500);
    }
}



    
}
