<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Validator;
use Carbon\Carbon;

class VisitLogController extends Controller
{
    
    // Add Visit
    public function addVisit(Request $request)
    {
        // validation code
        $request->validate([
            'iStudentId' => 'required|integer',
            'sRemark'    => 'required|string|max:500',
            'dtVisitDate'=> 'required|date',
        ]);
    
        try {
            $id = DB::table('tblvisitstatus')->insertGetId([
            // inserted data code
            'iStudentId'    => $request->iStudentId, // 👈 EXACT MATCH
            'sRemark'       => $request->sRemark,
            'dtVisitDate'   => $request->dtVisitDate,
            'iBisActive'    => 1,
            'dtUpdatedDate' => now()
            ]);
            // output code
            return response()->json([
                'result'  => 2,
                'message' => 'Appointment Added Successfully',
                'id'      => $id
            ], 201);
    
        } catch (\Exception $e) {
            return response()->json([
                'result'  => 0,
                'message' => 'Error: '.$e->getMessage()
            ], 500);
        }
}


    // Update Visit
    public function updateVisit(Request $request)
    {
    $request->validate([
        'iId'         => 'required|integer',
        'sRemark'     => 'required|string|max:500',
        'dtVisitDate' => 'required|date',
        'iBisActive'  => 'required|integer'
    ]);

    try {
        $updated = DB::table('tblvisitstatus')
            ->where('iId', $request->iId)
            ->update([
                'sRemark'       => $request->sRemark,
                'dtVisitDate'   => $request->dtVisitDate,
                'iBisActive'    => $request->iBisActive,
                'dtUpdatedDate' => Carbon::now()
            ]);

        if (!$updated) {
            return response()->json([
                'result'  => 0,
                'message' => 'Record Not Found'
            ]);
        }

        return response()->json([
            'result'  => 1,
            'message' => 'Record Updated Successfully'
        ]);

    } catch (\Exception $e) {
        return response()->json([
            'result'  => 0,
            'message' => 'Error: '.$e->getMessage()
        ], 500);
    }
}


    // Delete Visit
    public function deleteVisit($id)
    {
        try {
            $updated = DB::table('tblvisitstatus')
                ->where('iId', $id)
                ->where('iBisActive', 1) // only active records
                ->update([
                    'iBisActive' => 0,
                    'dtUpdatedDate' => now() // optional: update timestamp
                ]);
    
            if (!$updated) {
                return response()->json([
                    'result'  => 0,
                    'message' => 'Record Not Found'
                ]);
            }
    
            return response()->json([
                'result'  => 1,
                'message' => 'Record Deleted Successfully'
            ]);
    
        } catch (\Exception $e) {
            return response()->json([
                'result'  => 0,
                'message' => 'Error: ' . $e->getMessage()
            ], 500);
        }
    }


    
    // get all Visit
   public function getVisits()
    {
    try {
        $data = DB::table('tblvisitstatus')
            ->orderBy('iId','DESC')
            ->get();

        return response()->json([
            'result' => 1,
            'data'   => $data
        ]);

    } catch (\Exception $e) {
        return response()->json([
            'result'  => 0,
            'message' => 'Error: '.$e->getMessage()
        ], 500);
    }
}


    // get Visit id
    public function getVisitById($id)
    {
    try {
        $data = DB::table('tblvisitstatus')
            ->where('iId', $id)
            ->first();

        if (!$data) {
            return response()->json([
                'result'  => 0,
                'message' => 'Record Not Found'
            ]);
        }

        return response()->json([
            'result' => 1,
            'data'   => $data
        ]);

    } catch (\Exception $e) {
        return response()->json([
            'result'  => 0,
            'message' => 'Error: '.$e->getMessage()
        ], 500);
    }
}

}