<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Validator;
use Carbon\Carbon;
class YashogathaController extends Controller
{
    // Add Yashogatha
    public function addYashogatha(Request $request)
    {
        $request->validate([
            'sTitle'       => 'required|string|max:150',
            'sDescription' => 'required|string',
            'sPdfPath'     => 'nullable|string|max:255'
        ]);

        try {
            $id = DB::table('tblYashogatha')->insertGetId([
                'sTitle'        => $request->sTitle,
                'sDescription'  => $request->sDescription,
                'sPdfPath'      => $request->sPdfPath,
                'bIsActive'     => 1,
                'dtCreatedDate' => Carbon::now()
                
            ]);

            return response()->json([
                'result'  => 1,
                'message' => 'Yashogatha Added Successfully',
                'id'      => $id
            ], 201);

        } catch (\Exception $e) {
            return response()->json([
                'result'  => 0,
                'message' => 'Error: ' . $e->getMessage()
            ], 500);
        }
    }

    // Update Yashogatha
    public function updateYashogatha(Request $request)
    {
        $request->validate([
            'iId'          => 'required|integer',
            'sTitle'       => 'required|string|max:150',
            'sDescription' => 'required|string',
            'sPdfPath'     => 'nullable|string|max:255',
            'bIsActive'    => 'required|integer'
        ]);

        try {
            $updated = DB::table('tblYashogatha')
                ->where('iId', $request->iId)
                ->update([
                    'sTitle'        => $request->sTitle,
                    'sDescription'  => $request->sDescription,
                    'sPdfPath'      => $request->sPdfPath,
                    'bIsActive'     => $request->bIsActive,
                    'dtUpdatedDate' => Carbon::now()
                ]);

            if (!$updated) {
                return response()->json([
                    'result'  => 0,
                    'message' => 'Record Not Found'
                ]);
            }

            return response()->json([
                'result'  => 1,
                'message' => 'Yashogatha Updated Successfully'
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'result'  => 0,
                'message' => 'Error: ' . $e->getMessage()
            ], 500);
        }
    }

    // Delete Yashogatha (Soft Delete)
    public function deleteYashogatha($id)
    {
        try {
            $updated = DB::table('tblYashogatha')
                ->where('iId', $id)
                ->where('bIsActive', 1)
                ->update([
                    'bIsActive'     => 0,
                    'dtUpdatedDate' => Carbon::now()
                ]);

            if (!$updated) {
                return response()->json([
                    'result'  => 0,
                    'message' => 'Record Not Found'
                ]);
            }

            return response()->json([
                'result'  => 1,
                'message' => 'Yashogatha Deleted Successfully'
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'result'  => 0,
                'message' => 'Error: ' . $e->getMessage()
            ], 500);
        }
    }

    // Get All Yashogatha
    public function getYashogatha()
    {
        try {
            $data = DB::table('tblYashogatha')
                ->where('bIsActive', 1)
                ->orderBy('iId', 'DESC')
                ->get();

            return response()->json([
                'result' => 1,
                'data'   => $data
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'result'  => 0,
                'message' => 'Error: ' . $e->getMessage()
            ], 500);
        }
    }

    // Get Yashogatha By Id
    public function getYashogathaById($id)
    {
        try {
         $data = DB::table('tblYashogatha')
        ->where('iId', $id)
        ->where('bIsActive', 1)
        ->first();


            if (!$data) {
                return response()->json([
                    'result'  => 0,
                    'message' => 'Record Not Found'
                ]);
            }

            return response()->json([
                'result' => 1,
                'data'   => $data
            ]);

        } catch (\Exception $e) {
            return response()->json([
                'result'  => 0,
                'message' => 'Error: ' . $e->getMessage()
            ], 500);
        }
    }
}
