<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Validator;


class AppointmentController extends Controller
{
   
   
   //Add Appointment
    public function addAppointment(Request $request)
    {
        $request->validate([
            'iStudentId' => 'required|integer',
            'dtDate'     => 'required|date',
        ]);
    
        try {
            DB::beginTransaction();
    
            // Count appointments for the day
            $todayCount = DB::table('tblAppointment')
                ->where('dtDate', $request->dtDate)
                ->where('iBisActive', 1)
                ->lockForUpdate()
                ->count();
    
            $newSequence = $todayCount + 1;
    
            $id = DB::table('tblAppointment')->insertGetId([
                'iStudentId'    => $request->iStudentId,
                'dtDate'        => $request->dtDate,
                'iSequenceNo'   => $newSequence,
                'sStatus'       => 'Pending',
                'iBisActive'    => 1,
                'dtUpdatedDate' => now()
            ]);
    
            DB::commit();
    
            return response()->json([
                'result'  => 1,
                'message' => 'Appointment added successfully',
                'id'      => $id
            ], 201);
    
        } catch (\Exception $e) {
            DB::rollBack();
    
            return response()->json([
                'result'  => 0,
                'message' => 'Failed to add appointment',
                'error'   => $e->getMessage()
            ], 500);
        }
    }



    //get Appointment list optional date
    // public function getAppointmentList(Request $request)
    // {
    //     $query = DB::table('tblAppointment as a')
    
    //         // ðŸ”¹ Join visit status (optional)
    //         ->leftJoin('tblvisitstatus as v', function ($join) use ($request) {
    //             $join->on('a.iStudentId', '=', 'v.iStudentId')
    //                  ->where('v.iBisActive', 1);
    
    //             // Match visit date by DATE only (ignore time)
    //             if ($request->filled('dtDate')) {
    //                 $join->whereDate('v.dtVisitDate', $request->dtDate);
    //             }
    //         })
    
    //         // ðŸ”¹ Join student basic details
    //         ->leftJoin('tblregistration as s', function ($join) {
    //             $join->on('a.iStudentId', '=', 's.iId')
    //                  ->where('s.iBisActive', 1);
    //         })
    
    //         ->where('a.iBisActive', 1);
    
    //     // ðŸ“… Filter appointment by DATE only (ignore time)
    //     if ($request->filled('dtDate')) {
    //         $query->whereDate('a.dtDate', $request->dtDate);
    //     }
    
    //     // ðŸ“Œ Filter by appointment status
    //     if ($request->filled('status')) {
    //         $query->where('a.sStatus', $request->status);
    //     }
    
    //     $appointments = $query
    //         ->select(
    //             'a.*',
    //             'v.sRemark',
    //             'v.dtVisitDate',
    //             's.sFirstName',
    //             's.sMiddleName',
    //             's.sLastName',
    //             's.sGender',
    //             's.sCity',
    //             's.sStudentMobileNo',
    //             's.sParentMobileNo',
    //             's.sEmailId'
    //         )
    //         ->orderBy('a.iSequenceNo', 'ASC')
    //         ->get();
    
    //     return response()->json([
    //         'result'  => 1,
    //         'message' => $appointments->count() ? 'Data Found' : 'No Data Found',
    //         'data'    => $appointments
    //     ]);
    // }

public function getAppointmentList(Request $request)
{
    $query = DB::table('tblAppointment as a')

        // ✅ Latest visit status only
        ->leftJoin(DB::raw('(
            SELECT v1.*
            FROM tblvisitstatus v1
            WHERE v1.iBisActive = 1
              AND v1.dtVisitDate = (
                  SELECT MAX(v2.dtVisitDate)
                  FROM tblvisitstatus v2
                  WHERE v2.iStudentId = v1.iStudentId
                    AND v2.iBisActive = 1
              )
        ) as v'), function ($join) {
            $join->on('a.iStudentId', '=', 'v.iStudentId');
        })

        // student details
        ->leftJoin('tblregistration as s', function ($join) {
            $join->on('a.iStudentId', '=', 's.iId')
                 ->where('s.iBisActive', 1);
        })

        // slot booking
        ->leftJoin('tblSlotBooking as sb', function ($join) {
            $join->on('sb.iStudentId', '=', 'a.iStudentId')
                 ->where('sb.iBisActive', 1);
        })

        // slot details
        ->leftJoin('tblSlot as sl', function ($join) use ($request) {
            $join->on('sl.iId', '=', 'sb.iSlotId')
                 ->where('sl.iBisActive', 1);

            if ($request->filled('dtDate')) {
                $join->whereDate('sl.dtSlotDate', $request->dtDate);
            }
        })

        ->where('a.iBisActive', 1);

    // appointment date filter
    if ($request->filled('dtDate')) {
        $query->whereDate('a.dtDate', $request->dtDate);
    }

    // appointment status filter
    if ($request->filled('status')) {
        $query->where('a.sStatus', $request->status);
    }

    $appointments = $query
        ->select(
            'a.*',
            'v.sRemark',
            'v.dtVisitDate',
            's.iRegistrationId',
            's.sFirstName',
            's.sMiddleName',
            's.sLastName',
            's.sGender',
            's.sCity',
            's.sStudentMobileNo',
            's.sParentMobileNo',
            's.sEmailId',
            's.iCounsellingPackageId',
            's.iAppPackageId',
            's.iAmount',
            's.iPartialAmount',
            's.iConcession',
            's.iTotalAmount',
            's.sGroup',
            's.sActiveStatus',
            's.sFlag',
            's.sOtherDetails1',
            'sb.iId as slot_booking_id',
            'sb.sStatus as slot_booking_status',
            'sl.dtSlotDate',
            'sl.sStartTime',
            'sl.sEndTime'
        )
        ->orderBy('a.iSequenceNo', 'ASC')
        ->get();

    return response()->json([
        'result'  => 1,
        'message' => $appointments->count() ? 'Data Found' : 'No Data Found',
        'data'    => $appointments
    ]);
}





    
    
    // Update Appointment
    public function updateAppointment(Request $request)
    {
        $request->validate([
            'iId' => 'required|integer',
            'sStatus' => 'nullable|string|max:50' // Now optional
        ]);
    
        // Default status to "Ongoing" if not provided
        $status = $request->sStatus ?: 'Ongoing';
    
        $updated = DB::table('tblAppointment')
            ->where('iId', $request->iId)
            ->where('iBisActive', 1)
            ->update([
                'sStatus' => $status,
                'dtUpdatedDate' => now()
            ]);
    
        if ($updated) {
            return response()->json([
                'result'  => 1,
                'message' => 'Appointment Updated Successfully',
                'sStatus' => $status // return updated status
            ]);
        }
    
        return response()->json([
            'result'  => 0,
            'message' => 'Appointment Not Found'
        ]);
    }


    
    
    
    
    // Delete Appointment (Soft Delete)
    public function deleteAppointment(Request $request)
    {
        $request->validate([
            'iId' => 'required|integer'
        ]);
    
        $deleted = DB::table('tblAppointment')
            ->where('iId', $request->iId)
            ->update([
                'iBisActive'    => 0,
                'dtUpdatedDate' => now()
            ]);
    
        if ($deleted) {
            return response()->json([
                'result'  => 1,
                'message' => 'Appointment Deleted Successfully'
            ]);
        }
    
        return response()->json([
            'result'  => 0,
            'message' => 'Appointment Not Found'
        ]);
    }



}