<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class DashboardController extends Controller
{

    //get todays registred student count
    // public function getRegistrationCount()
    // {
    //     // Count today's student registrations from tblregistration
    //     $todayRegistrations = DB::table('tblregistration')
    //         ->where('iBisActive', 1)
    //         ->count();
    
    //     if ($todayRegistrations == 0) {
    //         return response()->json([
    //             'result' => 0,
    //             'message' => 'No registrations found for today',
    //         ], 404);  // 404 Not Found
    //     }
    
    //     return response()->json([
    //         'result' => 1,
    //         'message' => 'Today\'s registrations retrieved successfully',
    //         'totalRegistrations' => $todayRegistrations,
    //     ], 200);  // 200 OK

    // }
    
    // by darshana
    public function getRegistrationCount(Request $request)
    {
        // get fiscal year id from request
        $iFiscalyearid = $request->input('iFiscalyearid');
    
        if (!$iFiscalyearid) {
            return response()->json([
                'result' => 0,
                'message' => 'Fiscal year not provided'
            ], 400);
        }
    
        $totalRegistrations = DB::table('tblregistration')
            ->where('iBisActive', 1)
            ->where('iFiscalyearid', $iFiscalyearid) // year filter
            ->count();
    
        return response()->json([
            'result' => 1,
            'message' => 'Registrations retrieved successfully',
            'totalRegistrations' => $totalRegistrations,
        ], 200);
    }

    
    
    
    // get gender count
        // public function genderCounts()
        // {
        //     $counts = DB::table('tblregistration')
        //         ->select('sGender', DB::raw('COUNT(*) as total'))
        //         ->where('iBisActive', 1) 
        //         ->groupBy('sGender')
        //         ->get();
        
        //     $male = 0;
        //     $female = 0;
        
        //     foreach ($counts as $item) {
        //         if (strtolower($item->sGender) === 'male') {
        //             $male = $item->total;
        //         } elseif (strtolower($item->sGender) === 'female') {
        //             $female = $item->total;
        //         }
        //     }
        
        //     return response()->json([
        //         'result' => 1,
        //         'message' => 'Gender counts retrieved successfully',
        //         'male' => $male,
        //         'female' => $female,
        //     ]);
        // }
        
        
    // by darshana
    public function genderCounts(Request $request)
    {
        // get fiscal year id from request
        $iFiscalyearid = $request->input('iFiscalyearid');
    
        if (!$iFiscalyearid) {
            return response()->json([
                'result' => 0,
                'message' => 'Fiscal year not provided'
            ], 400);
        }
    
        $counts = DB::table('tblregistration')
            ->select('sGender', DB::raw('COUNT(*) as total'))
            ->where('iBisActive', 1)
            ->where('iFiscalyearid', $iFiscalyearid) // year filter
            ->groupBy('sGender')
            ->get();
    
        $male = 0;
        $female = 0;
    
        foreach ($counts as $item) {
            if (strtolower($item->sGender) === 'male') {
                $male = (int) $item->total;
            } elseif (strtolower($item->sGender) === 'female') {
                $female = (int) $item->total;
            }
        }
    
        return response()->json([
            'result' => 1,
            'message' => 'Gender counts retrieved successfully',
            'male' => $male,
            'female' => $female,
        ], 200);
    }

        
        
        
    // get last weeks registration count day by day
    public function dailyRegistrations()
    {
            $data = DB::table('tblregistration')
                ->selectRaw('DATE(dtUpdatedDate) as date, COUNT(*) as count')
                ->where('iBisActive', 1)
                ->where('dtUpdatedDate', '>=', now()->subDays(7))
                ->groupBy(DB::raw('DATE(dtUpdatedDate)'))
                ->orderBy('date', 'DESC')
                ->get();
        
            $dates = $data->pluck('date');
            $counts = $data->pluck('count');
        
            return response()->json([
                'dates' => $dates,
                'counts' => $counts,
            ]);
    }
    
    

        
        
        
        
        
    // get total fee paid
        // public function feePaidByMode()
        // {
        //     $payments = DB::table('tblPayment')
        //         ->select('sPaymentMode', DB::raw('SUM(fPaidAmount) as totalFeePaid'))
        //         ->where('iBisActive', 1)
        //         ->groupBy('sPaymentMode')
        //         ->pluck('totalFeePaid', 'sPaymentMode');
        
        //     return response()->json([
        //         'result' => 1,
        //         'message' => 'Fee paid data retrieved successfully',
        //         'data' => [
        //             'Cash' => $payments['Cash'] ?? 0,
        //             'Online' => $payments['Online'] ?? 0
        //         ],
        //     ], 200);
        // }
        
        
        public function feePaidByMode(Request $request)
        {
            $iFiscalyearid = $request->input('iFiscalyearid');
        
            if (!$iFiscalyearid) {
                return response()->json([
                    'result' => 0,
                    'message' => 'Fiscal year not provided'
                ], 400);
            }
        
            $payments = DB::table('tblPayment')
                ->select('sPaymentMode', DB::raw('SUM(fPaidAmount) as totalFeePaid'))
                ->where('iBisActive', 1)
                ->where('iFiscalyearid', $iFiscalyearid) // fiscal year filter
                ->groupBy('sPaymentMode')
                ->pluck('totalFeePaid', 'sPaymentMode');
        
            return response()->json([
                'result' => 1,
                'message' => 'Fee paid data retrieved successfully',
                'data' => [
                    'Cash'   => $payments['Cash'] ?? 0,
                    'Online' => $payments['Online'] ?? 0
                ],
            ], 200);
        }





    //Department wise total registered students
        // public function departmentWiseStudentCount()
        // {
        //     $results = DB::table('tblregistration')
        //         ->selectRaw("JSON_UNQUOTE(JSON_EXTRACT(iCounsellingPackageId, '$[0].sProgram')) AS department, COUNT(*) AS total_students")
        //         ->where('iBisActive', 1)
        //         ->groupBy('department')
        //         ->get();
        
        //     return response()->json([
        //         'result' => 1,
        //         'message' => 'Department-wise student count retrieved successfully.',
        //         'data' => $results
        //     ], 200);
        // }
        
    // by darshana
    public function departmentWiseStudentCount(Request $request)
    {
        $iFiscalyearid = $request->input('iFiscalyearid');
    
        if (!$iFiscalyearid) {
            return response()->json([
                'result' => 0,
                'message' => 'Fiscal year not provided'
            ], 400);
        }
    
        $results = DB::table('tblregistration')
            ->selectRaw("
                JSON_UNQUOTE(
                    JSON_EXTRACT(iCounsellingPackageId, '$[0].sProgram')
                ) AS department,
                COUNT(*) AS total_students
            ")
            ->where('iBisActive', 1)
            ->where('iFiscalyearid', $iFiscalyearid)   // fiscal year filter
            ->groupBy('department')
            ->get();
    
        return response()->json([
            'result' => 1,
            'message' => 'Department-wise student count retrieved successfully.',
            'data' => $results
        ], 200);
    }

 
 
 
 
 
     //get todays registred student count
    public function getTodaysRegistrationCount()
    {
        // Count today's student registrations from tblregistration
        $todayRegistrations = DB::table('tblregistration')
            ->whereDate('dtUpdatedDate', Carbon::today())
            ->count();
    
        if ($todayRegistrations == 0) {
            return response()->json([
                'result' => 0,
                'message' => 'No registrations found for today',
            ], 404);  // 404 Not Found
        }
    
        return response()->json([
            'result' => 1,
            'message' => 'Today\'s registrations retrieved successfully',
            'totalRegistrations' => $todayRegistrations,
        ], 200);  // 200 OK

    }
    
    
    
        // get total fee paid
        public function feePaidByModeDaily()
        {
            $payments = DB::table('tblPayment')
                ->select('sPaymentMode', DB::raw('SUM(fPaidAmount) as totalFeePaid'))
                 ->whereDate('dtUpdatedDate', Carbon::today())
                ->where('iBisActive', 1)
                ->groupBy('sPaymentMode')
                ->pluck('totalFeePaid', 'sPaymentMode');
        
            return response()->json([
                'result' => 1,
                'message' => 'Fee paid data retrieved successfully',
                'data' => [
                    'Cash' => $payments['Cash'] ?? 0,
                    'Online' => $payments['Online'] ?? 0
                ],
            ], 200);
        }


}

    
    



