<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;

class StudentQuotaController extends Controller
{
    public function addStudentQuotaWithDetails(Request $request)
    {
        try {
            //  Validate input
            $request->validate([
                'iStudentId' => 'required|integer',
                'iFee' => 'required|numeric',
                'iConcession' => 'required|numeric',
                'iPayableAmount' => 'required|numeric',
                'details' => 'required|array|min:1',
            ]);

            //  Insert into `tblStudentQuota`
            DB::table('tblStudentQuota')->insert([
                'iStudentId'     => $request->iStudentId,
                'iFee'           => $request->iFee,
                'iConcession'    => $request->iConcession,
                'iPayableAmount' => $request->iPayableAmount,
                'dtUpdateddate'  => now(),
                'iBisActive'     => 1,
            ]);

            // Insert multiple records into `tblStudentQuotaDetails`
            foreach ($request->details as $detail) {
                DB::table('tblStudentQuotaDetails')->insert([
                    'iStudentId'   => $request->iStudentId,
                    'sProgram'     => $detail['sProgram'],
                    'sState'       => $detail['sState'],
                    'sQuota'       => $detail['sQuota'],
                    'sCourseName'  => $detail['sCourseName'],
                    'dtUpdateddate'=> now(),
                    'iBisActive'   => 1,
                ]);
            }

            return response()->json(['result' => '1', 'message' => 'Record added successfully'], 201);
        } catch (\Exception $e) {
            return response()->json(['result' => '0', 'message' => $e->getMessage()], 500);
        }
    }


    public function getStudentQuota($studentId)
    {
        try {
            // Fetch main student quota record
            $studentQuota = DB::table('tblStudentQuota')->where('iStudentId', $studentId)->first();
    
            if (!$studentQuota) {
                return response()->json(['result' => '0', 'message' => 'Student not found']);
            }
    
            // Fetch related quota details
            $quotaDetails = DB::table('tblStudentQuotaDetails')->where('iStudentId', $studentId)->get();
    
            // Convert the studentQuota to an array and add the details as part of the array
            $studentQuotaArray = (array) $studentQuota; // Convert object to array
            $studentQuotaArray['details'] = $quotaDetails; // Add details to array
    
            return response()->json([
                'result' => '1',
                'studentQuota' => $studentQuotaArray, // Pass as array
            ], 200);
        } catch (\Exception $e) {
            return response()->json(['result' => '0', 'message' => $e->getMessage()], 500);
        }
    }



   public function updateStudentQuota(Request $request)
   {
    try {
        // Validate input
        $request->validate([
            'iStudentId' => 'required|numeric', // Ensure iStudentId is in the request
            'iFee' => 'required|numeric',
            'iConcession' => 'required|numeric',
            'iPayableAmount' => 'required|numeric',
            'details' => 'required|array|min:1',
        ]);

        $studentId = $request->iStudentId; // Extract iStudentId from the request

        // Check if student exists
        $student = DB::table('tblStudentQuota')->where('iStudentId', $studentId)->first();
        if (!$student) {
            return response()->json(['result' => '0', 'message' => 'Student not found'], 404);
        }

        DB::table('tblStudentQuota')->where('iStudentId', $studentId)->update([
            'iFee' => $request->iFee,
            'iConcession' => $request->iConcession,
            'iPayableAmount' => $request->iPayableAmount,
            'dtUpdateddate' => now(),
        ]);

        DB::table('tblStudentQuotaDetails')->where('iStudentId', $studentId)->delete();

        foreach ($request->details as $detail) {
            DB::table('tblStudentQuotaDetails')->insert([
                'iStudentId'   => $studentId, // Use the iStudentId from request
                'sProgram'     => $detail['sProgram'],
                'sState'       => $detail['sState'],
                'sQuota'       => $detail['sQuota'],
                'sCourseName'  => $detail['sCourseName'],
                'dtUpdateddate'=> now(),
                'iBisActive'   => 1,
            ]);
        }

        return response()->json(['result' => '3', 'message' => 'Record updated successfully'], 200);
    } catch (\Exception $e) {
        return response()->json(['result' => '0', 'message' => $e->getMessage()], 500);
    }
}




   // delete
    public function deleteStudentQuota($studentId)
    {
        try {
            // Check if student exists
            $student = DB::table('tblStudentQuota')->where('iStudentId', $studentId)->first();
            if (!$student) {
                return response()->json(['result' => '0', 'message' => 'Student not found'], 404);
            }

            // ✅ Soft delete: Set `iBisActive` to 0 in both tables
            DB::table('tblStudentQuota')->where('iStudentId', $studentId)->update(['iBisActive' => 0]);
            DB::table('tblStudentQuotaDetails')->where('iStudentId', $studentId)->update(['iBisActive' => 0]);

            return response()->json(['result' => '1', 'message' => 'Record soft deleted successfully'], 200);
        } catch (\Exception $e) {
            return response()->json(['result' => '0', 'message' => $e->getMessage()], 500);
        }
    }


 


}
