<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller; 
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;


class ConsellingPackageController extends Controller
{

    // add counselling package
    public function addPackage(Request $request)
    {
        $data = $request->only([
            'sProgram', 
            'iBisActive', 
            'iAmount',
            'sReveiverUpi',
            'dtUpdatedDate',
            'sOtherDetails1', 
            'sOtherDetails2',
            'sOtherDetails3'
        ]);
        $data['dtUpdatedDate'] = now();
        $data['iBisActive']=1;
        $id = DB::table('tblCounsellingPackage')->insertGetId($data);

        return response()->json(['result'=>'2','message' => 'Counselling package created successfully created', 'id' => $id], 201);
    }



    // Add Multiple packages
    public function addMultiplePackages(Request $request)
    {
        try {
            $packagesData = $request->input('data', []); // Expecting an array of packages
            $status = $request->input('status', 'append'); // 'addall' or 'append'

            if (empty($packagesData) || !is_array($packagesData)) {
                return response()->json(['result' => '0', 'message' => 'Invalid package data provided.'], 400);
            }

            // If status is 'addall', delete all existing records
            if ($status === 'addall') {
                DB::table('tblCounsellingPackage')->truncate();
            }

            $currentDate = now();
            $batchSize = 1800;
            $chunks = array_chunk($packagesData, $batchSize);

            foreach ($chunks as $chunk) {
                foreach ($chunk as &$data) {
                    $data['dtUpdatedDate'] = $currentDate;
                    $data['iBisActive'] = 1; // Mark as active
                }

                DB::table('tblCounsellingPackage')->insert($chunk);
            }

            return response()->json([
                'result'  => '2',
                'message' => count($packagesData) . ' packages added successfully.',
            ], 201);

        } catch (\Exception $e) {
            \Log::error('Error in addPackages:', [
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            return response()->json(['result' => '0', 'message' => 'An error occurred while adding packages.'], 500);
        }
    }



    // Update Conselling Package
    public function updateCounsellingPackage(Request $request)
    {
        $iId = $request->input('iId');
    
        if (!$iId) {
            return response()->json(['result' => '4', 'message' => 'Missing Package ID'], 400);
        }
    
        $data = $request->only([
            'sProgram', 
            'iAmount',
            'sReveiverUpi'
        ]);
    
        // Force update by adding timestamp
        $data['dtUpdatedDate'] = now();
    
        // Debugging: Check if ID exists
        $exists = DB::table('tblCounsellingPackage')->where('iId', $iId)->exists();
        if (!$exists) {
            return response()->json(['result' => '5', 'message' => 'Package Not Found'], 404);
        }
    
        $updated = DB::table('tblCounsellingPackage')->where('iId', $iId)->update($data);
    
        return response()->json([
            'result' => $updated ? '3' : '5',
            'message' => $updated ? 'Package Updated' : 'No Changes Made'
        ]);
    }
    


     // Get all records
     public function getAllPackages()
     {
          return response()->json(['result'=>'1','data'=>DB::table('tblCounsellingPackage')->where('iBisActive', 1)->get()]);
     }


    //  get distinct program
     public function getDisProgram()
     {
         $distinctPrograms = DB::table('tblCounsellingPackage')
             ->where('iBisActive', 1)
             ->select('sProgram') // Select only the 'sProgram' column
             ->distinct() // Ensure distinct values
             ->get();
     
         return response()->json(['result' => '1', 'data' => $distinctPrograms]);
     }
     

    // Get student profile by ID (Read)
    public function getPackage($id)
    {
        // Find student by ID using DB::table() 
        $student = DB::table('tblCounsellingPackage')
            ->where('iId', $id)
            ->first();  // Using first() to get a single result

        if (!$student) {
            // Return error if student not found
            return response()->json([
                'message' => 'package not found'
            ], 404);
        }

        // Return student data
        return response()->json($student);
    }




    //  delete couselling package
     public function deleteCounsellingPackage($iId)
     {
         $deleted = DB::table('tblCounsellingPackage')->where('iId', $iId)->update(['iBisActive' => 0]);
         if ($deleted) {
             return response()->json(['result'=>'4','message' => 'Counselling package deleted']);
         } else {
             return response()->json(['result'=>'5' ,'message' => 'Counselling package not found'], 404);
         }
     }
 
     
     

}
