<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class FiscalYearController extends Controller
{
    //Add Fiscal Year
    public function addFiscalYear(Request $request)
    {

        $request->validate([
            'sYear'   => 'required|string|max:20',
            'sRemark' => 'nullable|string|max:20',
            'sOtherDetails1' => 'nullable|integer',
        ]);
    
        $data = $request->only(['sYear','sRemark','sOtherDetails1']);
        $data['iBisActive']   = 1;
        $data['dtUpdatedDate'] = now();
    
        try {
            $id = DB::table('tblFiscalYear')->insertGetId($data);
            return response()->json([
                'result' => '2',
                'message' => 'Fiscal Year Added Successfully',
                'id' => $id
            ], 201);
        } catch (\Exception $e) {
            return response()->json([
                'result' => '0',
                'message' => 'Error: '.$e->getMessage()
            ], 500);
        }
    }
    
    
    
    //Update Fiscal Year
    public function updateFiscalYear(Request $request)
    {
        // Validate input, including iId from request
        $validated = $request->validate([
            'iId'            => 'required|integer',
            'sYear'          => 'required|string|max:20',
            'sRemark'        => 'nullable|string|max:20',
            'sOtherDetails1' => 'nullable|integer',
            'iBisActive'     => 'nullable|integer'
        ]);
    
        // Add updated timestamp
        $validated['dtUpdatedDate'] = now();
    
        try {
            // Use iId from request to find the record
          $updated = DB::table('tblFiscalYear')
             ->where('iId', $validated['iId'])
             ->update([
                 'sYear'          => $validated['sYear'],
                 'sRemark'        => $validated['sRemark'] ?? null,
                 'sOtherDetails1' => $validated['sOtherDetails1'] ?? null,
                 'iBisActive'     => $validated['iBisActive'] ?? 1,
                 'dtUpdatedDate'  => $validated['dtUpdatedDate']
             ]);

    
            if ($updated) {
                return response()->json([
                    'result'  => '2',
                    'message' => 'Fiscal Year Updated'
                ]);
            }
    
            return response()->json([
                'result'  => '1',
                'message' => 'No Record Updated'
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'result'  => '0',
                'message' => 'Error: '.$e->getMessage()
            ], 500);
        }
    }




    //get Fiscal Year
    public function getFiscalYear($id)
    {
    $data = DB::table('tblFiscalYear')->where('iId', $id)->first();

    if($data){
        return response()->json(['result'=>'2','data'=>$data]);
    }
    return response()->json(['result'=>'1','message'=>'Record Not Found']);
}



    //get all fiscal year
    public function getAllFiscalYears()
    {
    $data = DB::table('tblFiscalYear')
              ->orderBy('sYear','DESC')
              ->get();

    return response()->json(['result'=>'2','data'=>$data]);
}



    
}