<?php

namespace App\Http\Controllers\App;
use Illuminate\Support\Facades\Log;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class ImageUploadController extends Controller
{


    // Upload Images
    public function uploadImage(Request $request)
    {
        $request->validate([
            'image' => 'required|file|max:2048', // Validation rules
        ]);
    
        if ($request->hasFile('image')) {
            $image = $request->file('image');
    
            $imageName = uniqid('_', true) . '.' . $image->getClientOriginalExtension();
    
            $uploadPath = public_path('A2ZAdmission/upload');
    
            if (!file_exists($uploadPath)) {
                mkdir($uploadPath, 0777, true); 
            }
    
            $image->move($uploadPath, $imageName);
    
            $imageUrl = asset('A2ZAdmission/upload/' . $imageName);
    
            return response()->json([
                'result' => 1,
                'success' => true,
                'message' => 'Image uploaded successfully.',
                'image_path' => $imageUrl,
            ]);
        }
    
        return response()->json(['success' => false, 'message' => 'Image upload failed.']);
    }
    


    // Insert Image

    // public function insertImg(Request $request)
    // {
    //     // Ensure the input name matches the validation and file handling
    //     $request->validate([
    //         'image' => 'required|mimes:jpeg,png,jpg,gif,pdf|max:5120', 
    //     ]);
    
    //     // Check if the correct file input is present in the request
    //     if ($request->hasFile('image')) {
    //         $file = $request->file('image'); // Use the 'image' input field
            
    //         \Log::info('Received file for upload.', ['file_name' => $file->getClientOriginalName()]);
    
    //         $fileName = $file->getClientOriginalName(); // Keep the original filename
            
    //         $uploadPath = public_path('A2ZAdmission/upload');
    
    //         if (!file_exists($uploadPath)) {
    //             \Log::info('Directory does not exist, creating directory.', ['upload_path' => $uploadPath]);
    //             mkdir($uploadPath, 0777, true);
    //         }
    
    //         $file->move($uploadPath, $fileName);
    
    //         \Log::info('File moved successfully.', ['file_name' => $fileName, 'upload_path' => $uploadPath]);
    
    //         // Encode URL and remove spaces 
    //         $fileNameEncoded = urlencode($fileName); // Optionally, use str_replace(' ', '%20', $fileName) for more control
            
    //         // Generate the URL for the uploaded file with the encoded filename
    //         $fileUrl = asset('A2ZAdmission/upload/' . $fileNameEncoded);
    
    //         \Log::info('Generated file URL.', ['file_url' => $fileUrl]);
    
    //         // Return success response
    //         return response()->json([
    //             'result' => 1,
    //             'success' => true,
    //             'message' => 'File uploaded successfully.',
    //             'image_path' => $fileUrl,
    //         ]);
    //     }
    
    //     // Log the failure reason when no file is uploaded
    //     \Log::error('File upload failed. No file uploaded.', ['input_name' => 'image']);
    
    //     return response()->json(['success' => false, 'message' => 'File upload failed.']);
    // }
    
    
public function insertImg(Request $request)
{
    if (!$request->hasFile('image')) {
        return response()->json(['success' => false, 'message' => 'No file uploaded.']);
    }

    $file = $request->file('image');
    $allowedExtensions = ['jpg', 'jpeg', 'png', 'gif', 'pdf'];
    $extension = strtolower($file->getClientOriginalExtension());
    $maxSize = 5 * 1024 * 1024; // 5MB

    if (!in_array($extension, $allowedExtensions)) {
        return response()->json(['success' => false, 'message' => 'Invalid file type.']);
    }

    if ($file->getSize() > $maxSize) {
        return response()->json(['success' => false, 'message' => 'File size exceeds limit.']);
    }

    \Log::info('Received file for upload.', ['file_name' => $file->getClientOriginalName()]);

    // Sanitize filename: replace spaces, add timestamp for uniqueness
    $originalName = $file->getClientOriginalName();
    $baseName = pathinfo($originalName, PATHINFO_FILENAME);
    $baseNameSanitized = preg_replace('/[^A-Za-z0-9_\-]/', '_', $baseName);
    $uniqueName = time() . '_' . $baseNameSanitized . '.' . $extension;

    $uploadPath = public_path('A2ZAdmission/upload');

    if (!file_exists($uploadPath)) {
        \Log::info('Directory does not exist, creating directory.', ['upload_path' => $uploadPath]);
        mkdir($uploadPath, 0777, true);
    }

    $file->move($uploadPath, $uniqueName);
    \Log::info('File moved successfully.', ['file_name' => $uniqueName, 'upload_path' => $uploadPath]);

    // Generate URL with proper encoding
    $fileUrl = asset('A2ZAdmission/upload/' . rawurlencode($uniqueName));
    \Log::info('Generated file URL.', ['file_url' => $fileUrl]);

    return response()->json([
        'result' => 1,
        'success' => true,
        'message' => 'File uploaded successfully.',
        'image_path' => $fileUrl,
    ]);
}

}
